//------------------------------------------------------------------------------
// Tumar CSP
// Copyright (c) 2011 Scientific Lab. Gamma Technologies. All rights reserved.
// SDK
// Create KUR CMP Request
//------------------------------------------------------------------------------
#include "ex_util.h"
//------------------------------------------------------------------------------
#define CMP_KUR_FILE "cmp_kur.bin"
#define CMP_RA_CERT  "cmp_ra.cer"
#define CMP_KUR_CERT "kur.cer"
#define CMP_KUR_EXT  "ext_kur.bin"
//------------------------------------------------------------------------------
unsigned char WBuf[8196];
unsigned char Cert[8196];
unsigned char CerU[8196];
unsigned char Ext [1024];
//------------------------------------------------------------------------------
//        
// :
// 1.         CMP/KUR,  
//------------------------------------------------------------------------------
int main(void)
{
 int code;
 HCRYPTPROV hProv=0;
 HCRYPTKEY hKey,hExpKey,hKeyKUR;
 DWORD dw,len,sz,sk,se;

 //  
 code=LoadTumarCSP((char*)CSP_LIB); if (code) {printf("Load CSP error: %d\n",code); return 1;}
 //
 //    ( )
 if (getFileLen(CMP_RA_CERT,    &sz)) {printf("getFileLen error\r\n"); return 1;}
 if (readFile  (CMP_RA_CERT,Cert,sz)) {printf("readFile error\r\n");   return 1;}
 //   KUR
 if (getFileLen(CMP_KUR_CERT,    &sk)) {printf("getFileLen error\r\n"); return 1;}
 if (readFile  (CMP_KUR_CERT,CerU,sk)) {printf("readFile error\r\n");   return 1;}
 //   
 if (getFileLen(CMP_KUR_EXT,   &se)) {printf("getFileLen error\r\n"); return 1;}
 if (readFile  (CMP_KUR_EXT,Ext,se)) {printf("readFile error\r\n");   return 1;}
 //
 //   CSP
 if (!CPAcquireContext(&hProv,(char*)CSP_PROF,0,NULL)) {
   printf("CPAcquireContext Error: %0X\n",GetLastErrorCSP(0));
   return 1;
 }
 //    
 if (!CPGetUserKey(hProv,AT_SIGNATURE,&hKey)) {
   printf("CPGetUserKey AT_SIGNATURE Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //     CMP/KUR
 if (!CPGenKey(hProv,CALG_CMP_KEY,CRYPT_EXPORTABLE,&hExpKey)) {
   printf("CPGenKey CALG_CMP_KEY Error: %0X\r\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //   
 dw=PKI_CMP_KUR;
 if (!CPSetKeyParam(hProv,hExpKey,KP_CMP_TYPE,(BYTE*)&dw,0)) {
   printf("CPSetKeyParam KP_CMP_TYPE Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //    notAfter
 WBuf[0]=0x30;
 WBuf[1]=17;
 WBuf[2]=0x81;
 WBuf[3]=15;
 strcpy((char*)WBuf+4,"20121225121212Z");
 
 if (!CPSetKeyParam(hProv,hExpKey,KP_CMP_OVALID,WBuf,0)) {
   printf("CPSetKeyParam KP_CMP_OVALID Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 /*
 //
 // KP_CMP_EXT
 if (!CPSetKeyParam(hProv,hExpKey,KP_CMP_EXT,Ext,0)) {
   printf("CPSetKeyParam KP_CMP_EXT Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 */
 //
 
 //   
 if (!CPSetKeyParam(hProv,hExpKey,KP_CMP_EXP_KEY,(BYTE*)&hKey,0)) {
   printf("CPSetKeyParam KP_CMP_EXP_KEY Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //    ( )
 if (!CPSetKeyParam(hProv,hExpKey,KP_CMP_RCP_SUBJ,Cert,0)) {
   printf("CPSetKeyParam KP_CMP_RCP_SUBJ Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //   
 if (!CPImportKey(hProv,CerU,sk,0,0,&hKeyKUR)) {
   printf("CPImportKey Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 
 //     
 if (!CPSetKeyParam(hProv,hExpKey,KP_CMP_ADD_KEY,(BYTE*)&hKeyKUR,0)) {
   printf("CPSetKeyParam KP_CMP_ADD_KEY Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 
 //  
 len=sizeof(WBuf);
 if (!CPExportKey(hProv,0/*hKey*/,hExpKey,PUBLICKEYBLOB_CMP,0,WBuf,&len)) {
   printf("CPExportKey PUBLICKEYBLOB_CMP Error: %0X\r\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //  
 writeFile(CMP_KUR_FILE,WBuf,len);
 //
 CPDestroyKey(hProv,hKey);
 CPDestroyKey(hProv,hExpKey);
 //
 //   
 if (!CPImportKey(hProv,WBuf,len,0,0,&hKey)) {
   printf("CPImportKey Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //  transactionID  
 len=sizeof(WBuf);
 if (!CPGetKeyParam(hProv,hKey,KP_CMP_TRANS_ID,WBuf,&len,0)) {
   printf("CPGetKeyParam KP_CMP_TRANS_ID Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 WBuf[len]=0;
 printf("transactionID = %s\n",(char*)WBuf);
 CPDestroyKey(hProv,hKey);
 //   CSP
 CPReleaseContext(hProv,0);
 printf("OK\n");
 return 0;
}
//------------------------------------------------------------------------------
